Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 41.65, y = 38.12, z = 1, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["check_pass"] = 
{
	active = true, 
	effect_radius = 14, 
	position = { x = 37.8, y = 42.2, z = 1.1, f = 1.0}, 
	priority = 1, 
	think = "tf_check_pass", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 6, 
	position = { x = 47.1, y = 11.5, z = 0.4, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

trigger_functions =
{
tf_check_pass = function(trigger_id, time)
	local trigger = Triggers[trigger_id]

	if (getGVAR("spawn_army_ra") == _YES) then
		if((trigger.active == true) and (ARMY == Sectors.road_to_airport.owner) and (relations(ARMY, PLAYER) ~= ENEMY)) then
			checkPointer("road_to_airport", trigger_id, {"army_1", "army_2", "army_3", "army_4", "army_5", "army_6", "army_7", "army_8"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", true)
		end
	end
end,
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		finishMission(false)
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, ARMY)
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
